package com.qkdata.sms.service;

import lombok.extern.slf4j.Slf4j;

import java.util.regex.Pattern;

@Slf4j
public class AliPlaceholderResolver extends AbstractPlaceholderResolver {

	private static final Pattern PATTERN = Pattern.compile("\\$\\{(.*?)\\}");

	private static final String PLACEHOLDER_KEYWORD = "$";

	@Override
	protected String placeholderKeyword() {
		return PLACEHOLDER_KEYWORD;
	}

	@Override
	protected Pattern pattern() {
		return PATTERN;
	}
}
