package com.qkdata.sms.lmobile;


import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 个性化短信请求参数
 */
@Data
public class IndividuationSmsRequest implements Serializable {

    private static final long serialVersionUID = -1838385964799608368L;
    
    /**
     * 提交账户, 必传
     */
    @JsonProperty("User")
    private String user;

    /**
     * 提交账户密码, 必传
     */
    @JsonProperty("Password")
    private String password;

    /**
     * 企业代码, 非必传
     */
    @JsonProperty("CorpId")
    private String corpId;

    /**
     * 产品编号, 必传
     */
    @JsonProperty("ProductId")
    private String productId;

    /**
     * 短信变量, 必传
     */
    @JsonProperty("SmsVariable")
    private String smsVariable;

    /**
     * 短信模板， 必传
     */
    @JsonProperty("SmsTemplate")
    private String smsTemplate;

    /**
     * 用户自定义参数，长度<=32， 非必传
     */
    @JsonProperty("key")
    private String key;

}
