package com.qkdata.sms;

import com.qkdata.sms.constant.SmsTemplate;
import com.qkdata.sms.constant.SmsChannelEnum;
import com.qkdata.sms.constant.SmsTypeEnum;
import com.qkdata.sms.repository.SmsTemplateMapper;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.context.annotation.Profile;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringRunner;

import static org.junit.Assert.*;

@RunWith(SpringRunner.class)
@SpringBootTest(classes = {Application.class})
@ActiveProfiles(value = "dev")
public class SmsTemplateMapperTest {

    @Autowired
    private SmsTemplateMapper smsTemplateMapper;

    @Test
    public void testAdd() {
        SmsTemplate smsTemplate = new SmsTemplate();
        smsTemplate.setCode("YL_CAPTCHA_1");
        smsTemplate.setType(SmsTypeEnum.CAPTCHA);
        smsTemplate.setChannel(SmsChannelEnum.ALIBABA);
        smsTemplate.setStatus(1);
        smsTemplateMapper.insertSelective(smsTemplate);
    }

    @Test
    public void testSelectOne() {
        String code = "T_LG_CAPTCHA";
        SmsTemplate smsTemplate = smsTemplateMapper.selectOne(new SmsTemplate(code));
        assertNotNull(smsTemplate);
        assertEquals("T_LG_CAPTCHA", smsTemplate.getCode());
        assertSame(SmsTypeEnum.CAPTCHA, smsTemplate.getType());
        assertSame(SmsChannelEnum.ALIBABA, smsTemplate.getChannel());
    }
}
