package com.qkdata.sms.service;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@Service
@Slf4j
public class RedisService {

    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Autowired
    private RedisTemplate redisTemplate;

    public Long lpush(String queue, List<String> values) {
        Objects.requireNonNull(queue, "队列名称不能为空");
        if (CollectionUtils.isEmpty(values)) {
            throw new IllegalArgumentException("队列值不能为空");
        }
        return stringRedisTemplate.opsForList().leftPushAll(queue, values);
    }

    public void set(String key, Object value) {
        redisTemplate.opsForValue().set(key, value);
    }

    public void set(String key, Object value, long timeout, TimeUnit unit) {
        redisTemplate.opsForValue().set(key, value, timeout, unit);
    }

    public Object get(String key) {
        return redisTemplate.opsForValue().get(key);
    }

    public void delete(String key) {
        redisTemplate.opsForValue().getOperations().delete(key);
    }

    public void delete(Collection keys) {
        redisTemplate.opsForValue().getOperations().delete(keys);
    }

    public Set keys(String pattern){
        return redisTemplate.keys(pattern);
    }

    public Long rpush(String key, String value){
        return redisTemplate.opsForList().rightPush(key, value);
    }

    public List range(String key, Long start, Long end){
        return redisTemplate.opsForList().range(key, start, end);
    }
}
