package com.qkdata.sms.notification;

import com.qkdata.sms.model.LmobileNotifyCondition;

public class LmobileNotifyRequest extends AbstractNotifyRequest {

    private LmobileNotifyCondition condition;

    public LmobileNotifyRequest(LmobileNotifyCondition condition) {
        super();
        this.condition = condition;
        super.init();
    }

    @Override
    public void setSendTime() {
        super.notifyRequestDTO.setSendTime(condition.getSendedTime());
    }

    @Override
    public void setReportTime() {
        super.notifyRequestDTO.setReportTime(condition.getReportTime());
    }

    @Override
    public void setErrCode() {
        if (condition.getReportState()) {
            super.notifyRequestDTO.setErrCode("DELIVERED");
        } else {
            super.notifyRequestDTO.setErrCode("UNDELIVERD");
        }

    }

    @Override
    public void setErrMsg() {
        super.notifyRequestDTO.setErrMsg(condition.getSendResultInfo());
    }

    @Override
    public void setOutId() {
        super.notifyRequestDTO.setOutId(condition.getClientMsgId());
    }

}
