package com.qkdata.sms.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class SmsV1Condition {

    private static final long serialVersionUID = -7094472942961784909L;

    @NotBlank(message = "mobile不能为空")
    @Pattern(regexp = "^1[3,4,5,6,7,8,9]\\d{9}$", message = "手机号格式不正确")
    private String mobile;

    private String messageContent;
}
