package com.qkdata.sms.model;

import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.util.Map;

@Data
@NoArgsConstructor
public class  SmsCondition {

    /**
     * 手机号
     */
    @NotBlank(message = "手机号不能为空")
    @Pattern(regexp = "^1[3,4,5,6,7,8,9]\\d{9}$", message = "手机号格式不正确")
    private String mobile;

    /**
     * 模板编号
     */
    @NotBlank(message = "模板编号不能为空")
    private String code;

    /**
     * 模板参数, JSON格式
     */
    private Map<String, Object> params;

    private String outId;

    private String notifyUrl;

    private Integer channel;
}
