package com.qkdata.sms.model;


import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 个性化短信请求参数
 */
@Data
public class LmobileNotifyCondition implements Serializable {

    private static final long serialVersionUID = -1038085064793608368L;

    /**
     * 客户账号
     * 默认传递：是
     */
    @JsonProperty("AccountID")
    private String accountID;

    /**
     * 信息编号（同短信提交时产生的MsgID）
     * 默认传递：是
     */
    @JsonProperty("MsgID")
    private String msgID;

    /**
     * 客户提交手机号码
     * 默认传递：是
     */
    @JsonProperty("MobilePhone")
    private String mobilePhone;

    /**
     * 状态报告说明（运营商送达手机终端的回执），针对ReportState
     * 默认传递：是
     */
    @JsonProperty("ReportResultInfo")
    private String reportResultInfo;

    /**
     * 状态报告结果，True是成功，False是失败
     * 默认传递：是
     */
    @JsonProperty("ReportState")
    private Boolean reportState;

    /**
     * 状态报告时间
     * 默认传递：是
     */
    @JsonProperty("ReportTime")
    private String reportTime;

    /**
     * 发送结果，针对SendState
     * 默认传递：是
     */
    @JsonProperty("SendResultInfo")
    private String sendResultInfo;

    /**
     * 发送状态，供应商送达运营商网关的状态，True是成功，False是失败
     * 默认传递：是
     */
    @JsonProperty("SendState")
    private Boolean sendState;

    /**
     * 短信发送时间
     * 默认传递：是
     */
    @JsonProperty("SendedTime")
    private String sendedTime;

    /**
     * 长号码（下发端口号）
     * 默认传递：是
     */
    @JsonProperty("SPNumber")
    private String spNumber;

    /**
     * 自定义参数（可选），与短信提交接口g_SubmitWithKey中的Key一致
     * 默认传递：否
     */
    @JsonProperty("ClientMsgId")
    private String clientMsgId;

    /**
     * 扩展码
     * 默认传递：否
     */
    @JsonProperty("ExtendNum")
    private String extendNum;

    /**
     * 长短信序号
     * 默认传递：否
     */
    @JsonProperty("LongMsgNum")
    private String longMsgNum;

    /**
     * 长短信总条数
     * 默认传递：否
     */
    @JsonProperty("LongMsgTotal")
    private String longMsgTotal;
}
