package com.qkdata.sms.constant;

import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.time.LocalDateTime;

/**
 * 短信模板实体
 */
@Data
@NoArgsConstructor
@Entity
@Table(name = "sms_template")
public class SmsTemplate {

    /**
     * 主键
     */
    @Id
    @Column(name = "id")
    @GeneratedValue(generator = "JDBC")
    private Integer id;

    /**
     * 模板编号，自定义
     */
    @Column(name = "code")
    private String code;

    /**
     * 模板类型, 验证码类、通知类、交互类等
     */
    @Column(name = "type")
    private SmsTypeEnum type;

    /**
     * 优先使用渠道平台, 阿里短信平台、乐信通短信平台等
     */
    @Column(name = "channel")
    private SmsChannelEnum channel;

    /**
     * 模板状态
     */
    @Column(name = "status")
    private Integer status;

    /**
     * 阿里模板编号
     */
    @Column(name = "alibaba_template_code")
    private String alibabaTemplateCode;

    /**
     * 阿里模板内容
     */
    @Column(name = "alibaba_template_content")
    private String alibabaTemplateContent;

    /**
     * 阿里短信签名
     */
    @Column(name = "alibaba_sign_name")
    private String alibabaSignName;

    /**
     * 乐信通模板内容
     */
    @Column(name = "lmobile_template_content")
    private String lmobileTemplateContent;

    /**
     * 乐信通短信签名
     */
    @Column(name = "lmobile_sign_name")
    private String lmobileSignName;

    /**
     * 创建时间
     */
    @Column(name = "create_at")
    private LocalDateTime createAt;

    /**
     * 更新时间
     */
    @Column(name = "update_at")
    private LocalDateTime updateAt;

    public SmsTemplate(String code) {
        this.code = code;
    }
}
