package com.qkdata.sms.notification;

import com.aliyuncs.utils.StringUtils;
import com.qkdata.sms.model.NotifyRequestDTO;
import com.qkdata.sms.service.RedisService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
@Slf4j
public class NotifyTemplate {

    @Autowired
    private RedisService redisService;

    @Autowired
    private RestTemplate restTemplate;

    /**
     * 将短信报告存储到Redis中
     *
     * @param key
     * @param report
     */
    private void pushReportToRedis(String key, String report) {
        redisService.rpush(key, report);
    }

    /**
     * 实际回调
     *
     * @param notifyUrl
     * @param notifyRequest
     */
    private void request(String notifyUrl, NotifyRequest notifyRequest) {
        if (notifyRequest == null) {
            return;
        }
        NotifyRequestDTO notifyRequestDTO = notifyRequest.notifyRequest();
        if (notifyRequestDTO == null) {
            return;
        }

        // TODO 是否outId必须才回调
        if (StringUtils.isEmpty(notifyRequestDTO.getOutId())) {
            return;
        }

        String rep;
        try {
            rep = restTemplate.postForObject(notifyUrl, notifyRequestDTO, String.class);
            log.info("回调：{}，返回信息：{}", notifyUrl, rep);
        } catch (Exception e) {
            log.error("回调：{}失败", notifyUrl, e);
        }

        // TODO 是否需要加入重试
    }

    /**
     * 从Redis中获取回调地址
     *
     * @param key
     * @return
     */
    public String getNotifyUrl(String key) {
        return (String) redisService.get(key);
    }

    /**
     * 删除Redis中回调地址
     *
     * @param key
     */
    private void deleteNotificationUrlFromRedis(String key) {
        redisService.delete(key);
    }

    /**
     * 回调通知流程
     *
     * @param pushKey       存储短信报告Key
     * @param report        短信报告JSON字符串
     * @param notifyUrlKey  回调地址Key
     * @param notifyRequest 回调请求参数
     */
    public void notify(String pushKey, String report, String notifyUrl, String notifyUrlKey, NotifyRequest notifyRequest) {
        request(notifyUrl, notifyRequest);
        pushReportToRedis(pushKey, report);
        deleteNotificationUrlFromRedis(notifyUrlKey);
    }
}
