package com.qkdata.sms.service;

import com.qkdata.sms.exception.SmsException;
import com.qkdata.sms.constant.SmsResponseEnum;
import com.qkdata.sms.constant.SmsTemplate;
import com.qkdata.sms.model.InsertTemplateCondition;
import com.qkdata.sms.model.SmsTypeAndChannelDTO;
import com.qkdata.sms.repository.SmsTemplateMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class TemplateService {

    @Autowired
    private SmsTemplateMapper smsTemplateMapper;

    public List<SmsTemplate> smsTemplateList(){
        return smsTemplateMapper.selectAll();
    }

    public Integer insertTemplate(InsertTemplateCondition insertTemplateCondition) throws Exception{
        if (checkTemplateExist(insertTemplateCondition.getCode())){
            throw new SmsException("短信模板code已存在", SmsResponseEnum.TEMPLATE_CODE_ISEXIST);
        }
        SmsTemplate smsTemplate = new SmsTemplate();
        smsTemplate.setCode(insertTemplateCondition.getCode());
        smsTemplate.setType(insertTemplateCondition.getType());
        smsTemplate.setChannel(insertTemplateCondition.getChannel());
        smsTemplate.setAlibabaSignName(insertTemplateCondition.getAlibabaSignName());
        smsTemplate.setAlibabaTemplateCode(insertTemplateCondition.getAlibabaTemplateCode());
        smsTemplate.setAlibabaTemplateContent(insertTemplateCondition.getAlibabaTemplateContent());
        smsTemplate.setLmobileSignName(insertTemplateCondition.getLmobileSignName());
        smsTemplate.setLmobileTemplateContent(insertTemplateCondition.getLmobileTemplateContent());
        smsTemplateMapper.insertSelective(smsTemplate);
        return smsTemplate.getId();
    }

    private Boolean checkTemplateExist(String code){
        int count = smsTemplateMapper.selectCount(new SmsTemplate(code));
        if (count >= 1){
            return true;
        }
        return false;
    }

    public SmsTemplate getTemplateByCode(String code){
        SmsTemplate smsTemplate = smsTemplateMapper.selectOne(new SmsTemplate(code));
        return smsTemplate;
    }

    public Integer getTemplateCount(List<String> codeList){
        return smsTemplateMapper.countTemplateByCode(codeList);
    }

    public SmsTypeAndChannelDTO getTypeAndChannelByCode(String code) {
        return smsTemplateMapper.getTypeAndChannelByCode(code);
    }


}
