package com.qkdata.sms.service;

import com.qkdata.sms.exception.SmsException;
import org.springframework.util.StringUtils;

import java.util.Map;

public interface PlaceholderResolver {

	boolean isMatch(String template, Map<String, Object> params) throws SmsException;

	String replace(String template, Map<String, Object> params) throws SmsException;

	/**
	 * 模板内容是否包含占位符，简单的用$判断，所以模板正式内容不能出现此字符
	 * @param template    模板内容
	 * @param keyword 占位符关键字, ali为$, lmobile为#
	 * @return 是否包含
	 */
	default boolean hasPlaceholder(String template, String keyword) {
		if (!StringUtils.isEmpty(template) && template.indexOf(keyword) > 0) {
			return true;
		}
		return false;
	}

}
