package com.qkdata.sms.model;

import com.qkdata.sms.constant.SmsChannelEnum;
import com.qkdata.sms.constant.SmsTypeEnum;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 短信发送统一请求参数
 */
@Data
public class InsertTemplateCondition implements Serializable {

    private static final long serialVersionUID = 462051340401877051L;

    @NotBlank(message = "模板code不能为空")
    private String code;

    @NotNull(message = "模板类型不能为空")
    private SmsTypeEnum type;

    @NotNull(message = "优先使用平台不能为空")
    private SmsChannelEnum channel;

    @NotBlank(message = "阿里短信code不能为空")
    private String alibabaTemplateCode;

    @NotBlank(message = "阿里短信模板不能为空")
    private String alibabaTemplateContent;

    @NotBlank(message = "阿里短信签名不能为空")
    private String alibabaSignName;

    @NotBlank(message = "乐信通短信模板不能为空")
    private String lmobileTemplateContent;

    @NotBlank(message = "乐信通短信签名不能为空")
    private String lmobileSignName;
}
