package com.qkdata.sms.consumer;

import com.github.rholder.retry.Attempt;
import com.github.rholder.retry.RetryListener;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class SmsRetryListener implements RetryListener {

    @Override
    public <Boolean> void onRetry(Attempt<Boolean> attempt) {
        log.info("第{}次重试， 距离第一次重试的延迟: {}", attempt.getAttemptNumber(), attempt.getDelaySinceFirstAttempt());

        if (attempt.hasException()) {
            log.error("重试由于异常终止", attempt.getExceptionCause());
        } else {
            log.info("重试返回结果: {}", attempt.getResult());
        }
    }
}
