package com.qkdata.sms.constant;

/**
 * @author chenjiahai
 * @date 17/9/27
 */
public enum SmsResponseEnum implements CommonResponseEnum {

    SEND_ERROR(92000, "发送短信失败"),
    EMPTY_CAPTCHA(92001, "验证码不能为空"),
    INVALID_CAPTCHA(92002, "不合法的验证码"),
    TEMPLATE_CODE_ISEXIST(92003, "短信模板code已存在"),
    TEMPLATE_NOT_EXIST(92004, "短信模板不存在"),
    TEMPLATE_PARAMS_MISMATCHED(92005, "模板参数与模板变量不符"),
    TEMPLATE_ERROR(92006, "短信模板错误");

    private Integer value;

    private String text;

    SmsResponseEnum(Integer value, String text) {
        this.value = value;
        this.text = text;
    }

    @Override
    public Integer value() {
        return value;
    }

    @Override
    public String text() {
        return text;
    }
}
