package com.qkdata.sms.api;

import com.qkdata.sms.exception.SmsException;
import com.qkdata.sms.service.TemplateService;
import com.qkdata.sms.constant.ResponseData;
import com.qkdata.sms.model.InsertTemplateCondition;
import com.qkdata.sms.model.SmsMessageCondition;
import com.qkdata.sms.model.SmsV1Condition;
import com.qkdata.sms.service.SmsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.io.IOException;

/**
 * @author chenjiahai
 * @date 17/9/25
 */
@RestController
@RequestMapping("api")
public class SmsController {

    @Autowired
    private SmsService smsService;

    @Autowired
    private TemplateService templateService;

    @PostMapping("v3")
    public ResponseData sendSmsV3(@RequestBody @Valid SmsMessageCondition condition) throws Exception {
        smsService.send(condition);
        return ResponseData.build();
    }

    @GetMapping("v1/templates")
    public ResponseData smsTemplateList() {
        return ResponseData.builder()
                           .data("templates", templateService.smsTemplateList())
                           .build();
    }

    @PostMapping("v1/templates")
    public ResponseData insertTemplate(@RequestBody @Valid InsertTemplateCondition insertTemplateCondition) throws Exception {
        return ResponseData.builder()
                           .data("templateId", templateService.insertTemplate(insertTemplateCondition))
                           .build();
    }

    @GetMapping("v1/sms")
    public ResponseData sendSms(SmsV1Condition smsCondition) throws SmsException, IOException {
        smsService.sendSms(smsCondition);
        return ResponseData.build();
    }


}

