package com.qkdata.sms.util;

import lombok.extern.slf4j.Slf4j;

import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;

/**
 * @author chenjiahai
 */
@Slf4j
public class JaxbUtils {

	private static JAXBContext jaxbContext;

	//xml转java对象
	@SuppressWarnings("unchecked")
	public static <T> T xmlToBean(HttpServletRequest request, Class<T> c) {
		T t = null;
		try {
			jaxbContext = JAXBContext.newInstance(c);
			Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
			t = (T) unmarshaller.unmarshal(request.getInputStream());
		} catch (JAXBException e) {
			log.error("JAXB异常", e);
		} catch (IOException e) {
			log.error("获取request中的inputStream失败", e);
		}
		return t;
	}

	public static <T> T xmlToBean(String xml, Class<T> c) {
		T t = null;
		try {
			jaxbContext = JAXBContext.newInstance(c);
			Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
			t = (T) unmarshaller.unmarshal(new StringReader(xml));
		} catch (JAXBException e) {
			log.error("JAXB异常", e);
		}
		return t;
	}

	//java对象转xml
	public static String beanToXml(Object obj) {
		return beanToXml(obj, false);
	}

	public static String beanToXml(Object obj, boolean format) {
		StringWriter writer = null;
		try {
			jaxbContext = JAXBContext.newInstance(obj.getClass());
			Marshaller marshaller = jaxbContext.createMarshaller();
			//Marshaller.JAXB_FRAGMENT:是否省略xml头信息,true省略，false不省略
			marshaller.setProperty(Marshaller.JAXB_FRAGMENT, true);
			//Marshaller.JAXB_FORMATTED_OUTPUT:决定是否在转换成xml时同时进行格式化（即按标签自动换行，否则即是一行的xml）
			marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, format);
			//Marshaller.JAXB_ENCODING:xml的编码方式
			marshaller.setProperty(Marshaller.JAXB_ENCODING, "UTF-8");
			writer = new StringWriter();
			marshaller.marshal(obj, writer);
		} catch (JAXBException e) {
			log.error("JAXB-Java对象转XML", e);
			return "";
		}
		return writer.toString();
	}
}  