package com.qkdata.sms.service;

import com.qkdata.sms.exception.SmsException;
import lombok.extern.slf4j.Slf4j;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Slf4j
public class LmobilePlaceholderResolver extends AbstractPlaceholderResolver {

	private static final Pattern PATTERN = Pattern.compile("#(.*?)#");

	private static final String PLACEHOLDER_KEYWORD = "#";

	@Override
	protected String placeholderKeyword() {
		return PLACEHOLDER_KEYWORD;
	}

	@Override
	protected Pattern pattern() {
		return PATTERN;
	}

	@Override
	public String replace(String template, Map<String, Object> params) throws SmsException {
		String result = template;
		if (isMatch(template, params)) {
			Matcher matcher = PATTERN.matcher(template);
			while (matcher.find()) {
				String paramKey = matcher.group(1);
				String value = (String) params.get(paramKey);
				result = result.replace(matcher.group(0), value);
			}
		}
		return result;
	}
}
