package com.qkdata.sms.notification;

import com.qkdata.sms.model.SmsReport;

public class AliNotifyRequest extends AbstractNotifyRequest {

    private SmsReport smsReport;

    public AliNotifyRequest(SmsReport smsReport) {
        super();
        this.smsReport = smsReport;
        super.init();
    }

    @Override
    public void setSendTime() {
        super.notifyRequestDTO.setSendTime(smsReport.getSend_time());
    }

    @Override
    public void setReportTime() {
        super.notifyRequestDTO.setReportTime(smsReport.getReport_time());
    }

    @Override
    public void setErrCode() {
        if (!"DELIVERED".equals(smsReport.getErr_code())) {
            super.notifyRequestDTO.setErrCode("UNDELIVERD");
        } else {
            super.notifyRequestDTO.setErrCode(smsReport.getErr_code());
        }
    }

    @Override
    public void setErrMsg() {
        super.notifyRequestDTO.setErrMsg(smsReport.getErr_msg());
    }

    @Override
    public void setOutId() {
        super.notifyRequestDTO.setOutId(smsReport.getOut_id());
    }

}
