package com.qkdata.sms.model;

import java.io.Serializable;

import javax.validation.constraints.Pattern;

import org.hibernate.validator.constraints.NotBlank;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class SmsAliCondition implements Serializable {

    /**
     * 
     */
    private static final long serialVersionUID = 8199548590381624271L;

    @NotBlank(message = "手机号不能为空")
    @Pattern(regexp = "^1[3,4,5,6,7,8,9]\\d{9}$", message = "手机号格式不正确")
    private String mobile;

    @NotBlank(message = "签名不能为空")
    private String signName;

    @NotBlank(message = "模板编号不能为空")
    private String templateCode;

    @NotBlank(message = "模板参数不能为空")
    private String templateParam;

    @NotBlank(message = "outId不能为空")
    private String outId;

}
