package com.qkdata.sms.lmobile;


import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

/**
 * 用于提交发送短信的常规方法
 */
@Data
public class RegularSmsRequest implements Serializable {

    private static final long serialVersionUID = -5139319999792779765L;

    private static final DateTimeFormatter FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    /**
     * 提交账户，必传
     */
    @JsonProperty("sname")
    private String user;

    /**
     * 提交账户的密码，必传
     */
    @JsonProperty("spwd")
    private String password;

    /**
     * 企业代码，非必传
     */
    @JsonProperty("scorpid")
    private String corpId;

    /**
     * 产品编号，必传
     */
    @JsonProperty("sprdid")
    private String productId;

    /**
     * 接收号码间用英文半角逗号","隔开,触发产品一次只能提交一个
     * 其他产品一次不能超过10万个号码
     */
    @JsonProperty("sdst")
    private String mobiles;

    /**
     * 短信内容
     */
    @JsonProperty("smsg")
    private String content;

    /**
     * 短信定时时间，格式:yyyy-MM-dd HH:mm:ss，要求大于当前时间并且小于当前时间+31天
     */
    private LocalDateTime beginDate;

    /**
     * 用户自定义参数，长度<=32
     */
    @JsonProperty("key")
    private String key;

    @JsonProperty("sbegindate")
    public String getBeginDate() {
        if (beginDate == null) {
            return null;
        }
        return beginDate.format(FORMAT);
    }
}
