package com.qkdata.sms.constant;

import java.util.List;

/**
 *
 * @author chenjiahai
 * @date 17/5/19
 */
public class ResponseDataBuilder {

	private ResponseData responseData;

	public ResponseDataBuilder(ResponseData responseData) {
		this.responseData = responseData;
	}

	public ResponseDataBuilder code(Integer code) {
		responseData.setCode(code);
		return this;
	}

	public ResponseDataBuilder message(String userMessage) {
		responseData.setMessage(userMessage);
		return this;
	}

	public ResponseDataBuilder result(CommonResponseEnum responseEnum) {
		responseData.setCode(responseEnum.value());
		responseData.setMessage(responseEnum.text());
		return this;
	}

	public ResponseDataBuilder data(String key, Object value) {
		responseData.getData().put(key, value);
		return this;
	}

	public ResponseDataBuilder errors(List<Object> errors) {
		responseData.setErrors(errors);
		return this;
	}

	public ResponseData build() {
		return responseData;
	}

}
