package com.qkdata.sms.constant;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.springframework.http.HttpStatus;

import com.fasterxml.jackson.annotation.JsonIgnore;

import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * RESTFUL接口统一返回
 *
 * @author chenjiahai
 * @date 17/5/9
 */
@Data
@NoArgsConstructor
public class ResponseData implements Serializable {

	private static final long serialVersionUID = -3856663982622822873L;

	/**
	 * 业务编码
	 */
	private Integer code = ConstantResponseEnum.OK.value();

	/**
	 * 对用户友好的提示信息, 供前端显示使用
	 */
	private String message = ConstantResponseEnum.OK.text();

	/**
	 * 业务数据
	 */
	private Map<String, Object> data = new LinkedHashMap<>();

	/**
	 * 不合法参数
	 */
	private List<Object> errors;

	@JsonIgnore
	private CommonResponseEnum responseEnum;

	public static ResponseDataBuilder builder() {
		return new ResponseDataBuilder(new ResponseData());
	}

	/**
	 * 默认ResponseData: code为0, message为OK
	 *
	 * @return
	 */
	public static ResponseData build() {
		return builder().build();
	}

	public ResponseData(CommonResponseEnum responseEnum) {
		this.code = responseEnum.value();
		this.message = responseEnum.text();
	}

	public ResponseData(HttpStatus httpStatus, String message) {
		this.code = httpStatus.value();
		this.message = message;
	}

	public ResponseData(HttpStatus httpStatus, String message, List<Object> errors) {
		this(httpStatus, message);
		this.errors = errors;
	}
}
