package com.qkdata.sms.api;

import com.qkdata.sms.model.LmobileNotifyCondition;
import com.qkdata.sms.model.SmsReport;
import com.qkdata.sms.service.SmsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.configurationprocessor.json.JSONObject;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author chenjiahai
 * @date 17/9/25
 */
@RestController
@RequestMapping
public class SmsNotifyController {

    @Autowired
    private SmsService smsService;

    @PostMapping("lmobile-notify")
    @ResponseStatus(HttpStatus.OK)
    public void receive(LmobileNotifyCondition lmobileNotifyCondition) {
        smsService.lmobileNotify(lmobileNotifyCondition);
    }

    @PostMapping("ali-notify")
    public ResponseEntity receive(@RequestBody List<SmsReport> smsReports) throws Exception {
        smsService.aliNotify(smsReports);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("code", 0);
        jsonObject.put("msg", "成功");
        return ResponseEntity.ok(jsonObject.toString());
    }


}

