package com.qkdata.sms.exception;

import com.qkdata.sms.constant.CommonResponseEnum;

/**
 * 业务异常基类
 *
 * @author chenjiahai
 * @date 17/5/11
 */
public class BusinessException extends Exception {

	private static final long serialVersionUID = 1506455046341195098L;

	protected final CommonResponseEnum responseEnum;

	public BusinessException(CommonResponseEnum responseEnum) {
		this.responseEnum = responseEnum;
	}

	public BusinessException(String message, CommonResponseEnum responseEnum) {
		super(message);
		this.responseEnum = responseEnum;
	}

	public CommonResponseEnum responseEnum() {
		return responseEnum;
	}
}
