package com.qkdata.sms.consumer;

import com.qkdata.sms.exception.SmsException;
import com.qkdata.sms.exception.SmsRemoteApiException;
import com.qkdata.sms.model.SmsCondition;
import com.qkdata.sms.service.SmsSender;
import lombok.extern.slf4j.Slf4j;

import java.util.concurrent.Callable;

@Slf4j
public class SendSmsTask implements Callable<Boolean> {

    private SmsCondition smsCondition;

    private SmsSender aliSmsSender;

    private SmsSender lmobileSmsSender;

    private SmsSender current;

    public SendSmsTask(SmsCondition smsCondition, SmsSender aliSmsSender, SmsSender lmobileSmsSender) {
        this.smsCondition = smsCondition;
        this.aliSmsSender = aliSmsSender;
        this.lmobileSmsSender = lmobileSmsSender;
    }

    @Override
    public Boolean call() throws SmsException {
        try {
            switchSmsSender();
            log.info("即将使用短信平台: {}, 发送短信: {}", this.current.getClass().getSimpleName(), this.smsCondition);
            current.send(smsCondition);
        } catch (SmsException e) {
            throw e;
        } catch (SmsRemoteApiException e) {
            log.error("调用短信平台接口失败", e);
            return false;
        }
        return true;
    }

    private void switchSmsSender() {
        Integer smsChannel = this.smsCondition.getChannel();
        if (this.current == null && smsChannel == 1) {
            this.current = aliSmsSender;
        } else if (this.current == null && smsChannel == 2) {
            this.current = lmobileSmsSender;
        } else if (this.current != null && this.current == aliSmsSender) {
            this.current = lmobileSmsSender;
        } else if (this.current != null && this.current == lmobileSmsSender) {
            this.current = aliSmsSender;
        } else {
            this.current = lmobileSmsSender;
        }
    }

    public SmsCondition getSmsCondition(){
        return this.smsCondition;
    }

}
