package com.qkdata.biz.management.controller;

import com.qkdata.biz.common.BizConstants;
import com.qkdata.biz.management.service.PriceConfigService;
import com.qkdata.biz.management.vo.PriceConfigModel;
import com.qkdata.common.annotation.SysLog;
import com.qkdata.common.base.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@Api(tags = "会员价格配置")
@RestController
@RequestMapping("/api/mgr/priceConfig")
public class PriceConfigController {

    @Autowired
    private PriceConfigService priceConfigService;

    @ApiOperation("获取系统价格配置")
    @GetMapping("/get")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    public Result<PriceConfigModel> get() {
        return Result.succeed(priceConfigService.findConfig());
    }

    @ApiOperation("修改系统价格配置")
    @SysLog("修改系统价格配置")
    @PostMapping("/update")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    public Result<String> update(@RequestBody PriceConfigModel model) {
        priceConfigService.update(model);
        return Result.succeed("ok");
    }

}
