package com.qkdata.common.converter;

import com.qkdata.common.base.exception.BusinessException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.StringUtils;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;

/**
 * 用于QUERY参数转换成LocalDate
 */
@Slf4j
public class StringToLocalDateConverter implements Converter<String, LocalDate> {

    @Override
    public LocalDate convert(String source) {
        if (StringUtils.isEmpty(source)) {
            return null;
        }
        try {
            return Instant.ofEpochMilli(Long.valueOf(source)).atZone(ZoneId.systemDefault()).toLocalDate();
        } catch (Exception e) {
            log.warn("时间转换异常", e);
            throw new BusinessException("时间转换异常");
        }

    }
}
