package com.qkdata.biz.web.controller;

import com.qkdata.biz.common.BizConstants;
import com.qkdata.biz.management.entity.CourseConsumeRecordPO;
import com.qkdata.biz.web.vo.SaveConsumeRecord;
import com.qkdata.common.annotation.SysLog;
import com.qkdata.common.base.model.Result;
import com.qkdata.common.util.UserContext;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.concurrent.TimeUnit;

@Api(tags = "课程消耗记录")
@RestController
@RequestMapping("/api/consumeRecord")
public class CourseConsumeRecordController {
    @Autowired
    @Qualifier("objectRedisTemplate")
    private RedisTemplate redisTemplate;

    @ApiOperation("记录课程消耗记录")
    @PostMapping("/save")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    @SysLog("记录课程消耗记录")
    public Result<String> save(@RequestBody SaveConsumeRecord model){
        //缓存用户观看记录
        redisTemplate.opsForValue().set("record_"+UserContext.getUserId()+"_"+model.getCourseId(),model, 5,TimeUnit.MINUTES);
        //缓存课程观看记录
        if(redisTemplate.opsForHash().hasKey(BizConstants.CACHE_KE_CONSUME_RECORD,model.getUuid())){
            CourseConsumeRecordPO cacheModel = (CourseConsumeRecordPO) redisTemplate.opsForHash().get(BizConstants.CACHE_KE_CONSUME_RECORD,model.getUuid());
            cacheModel.setWatchTime(model.getLearnDuration());
            cacheModel.setVideoTime(model.getVideoDuration());
            cacheModel.setUpdateTime(LocalDateTime.now());
            redisTemplate.opsForHash().put(BizConstants.CACHE_KE_CONSUME_RECORD,cacheModel.getId(),cacheModel);
        }else {
            CourseConsumeRecordPO po = new CourseConsumeRecordPO();
            po.setId(model.getUuid());
            po.setUserId(UserContext.getUserId());
            po.setCourseId(model.getCourseId());
            po.setChapterId(model.getChaperId());
            po.setWatchTime(model.getLearnDuration());
            po.setVideoTime(model.getVideoDuration());
            po.setCreateTime(model.getStartTime());
            po.setUpdateTime(model.getStartTime());
            redisTemplate.opsForHash().put(BizConstants.CACHE_KE_CONSUME_RECORD,po.getId(),po);
        }

        return Result.succeed("ok");
    }

}
