package com.qkdata.biz.sys.service;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.qkdata.biz.sys.entity.SysRolePO;
import com.qkdata.biz.sys.mapper.SysRoleMapper;
import com.qkdata.biz.sys.vo.QueryRoleModel;
import com.qkdata.biz.sys.vo.RoleMenuPermissionModel;
import com.qkdata.biz.sys.vo.SysRoleModel;
import com.qkdata.common.base.entity.BasePO;
import com.qkdata.common.base.enums.CodeEnum;
import com.qkdata.common.base.exception.BusinessException;
import com.qkdata.common.base.model.PageResult;
import com.qkdata.common.base.service.impl.BaseServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.stream.Collectors;

@Service
public class SysRoleService extends BaseServiceImpl<SysRoleMapper, SysRolePO> {
    @Autowired
    private SysRoleMenuService sysRoleMenuService;

    public PageResult<SysRolePO> queryPageList(QueryRoleModel queryRoleModel) {
        Page<SysRolePO> page = new Page<>(queryRoleModel.getPageIndex(),queryRoleModel.getPageSize());
        List<SysRolePO> pageList = baseMapper.queryPageList(page,queryRoleModel);
        return PageResult.<SysRolePO>builder().code(CodeEnum.SUCCESS.getCode()).count(page.getTotal()).data(pageList).build();
    }

    public SysRoleModel getRoleInfo(Long id) {
        SysRolePO po = getById(id);
        if (po == null){
            throw new BusinessException("请求错误，未找到对应角色");
        }
        List<Long> menuIds = sysRoleMenuService.queryMenuIdList(po.getId());
        SysRoleModel model = new SysRoleModel();
        BeanUtils.copyProperties(po,model);
//        model.setMenuIdList(menuIds);
        return model;
    }

    @Transactional
    public void saveRole(SysRoleModel sysRoleModel) {
        SysRolePO po = new SysRolePO();
        BeanUtils.copyProperties(sysRoleModel,po);
        save(po);
//        sysRoleMenuService.saveOrUpdateRoleMenu(po.getId(),sysRoleModel.getMenuIdList());
    }

    @Transactional
    public void updateRole(SysRoleModel sysRoleModel) {
        SysRolePO po = getById(sysRoleModel.getId());
        if (po == null){
            throw new BusinessException("请求错误，角色不存在");
        }
        po.setName(sysRoleModel.getName());
        po.setCode(sysRoleModel.getCode());
        updateById(po);

//        sysRoleMenuService.saveOrUpdateRoleMenu(po.getId(),sysRoleModel.getMenuIdList());
    }

    public List<SysRoleModel> getUserRoles(Long userId) {
        return baseMapper.findUserRoles(userId);
    }

    public List<Long> findRoleMenuIds(Long roleId) {
        return sysRoleMenuService.findRoleMenuIds(roleId);
    }

    public void saveRoleMenuPermission(RoleMenuPermissionModel model) {
        sysRoleMenuService.saveOrUpdateRoleMenu(model.getRoleId(),model.getMenuIds());
    }

    public List<SysRolePO> getByCodes(List<String> roleCodeList) {
        return list(Wrappers.<SysRolePO>lambdaQuery().in(SysRolePO::getCode,roleCodeList));

    }
}
