package com.qkdata.biz.web.controller;

import com.aliyuncs.vod.model.v20170321.GetVideoPlayAuthResponse;
import com.qkdata.biz.common.BizConstants;
import com.qkdata.biz.management.service.CourseService;
import com.qkdata.biz.management.service.ProductOrderService;
import com.qkdata.biz.management.vo.ProductOrderModel;
import com.qkdata.biz.management.vo.QueryFavoriteCourseModel;
import com.qkdata.biz.management.vo.QueryProductOrderModel;
import com.qkdata.biz.sys.service.SysUserService;
import com.qkdata.biz.web.service.UserCenterService;
import com.qkdata.biz.web.vo.*;
import com.qkdata.common.annotation.SysLog;
import com.qkdata.common.base.model.PageResult;
import com.qkdata.common.base.model.Result;
import com.qkdata.common.util.UserContext;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Api(tags = "我的相关数据接口-手机端")
@RestController
@RequestMapping("/api/userCenter")
public class UserCenterController {
    @Autowired
    private UserCenterService userCenterService;
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private CourseService courseService;
    @Autowired
    private ProductOrderService orderService;

    @ApiOperation("获取个人信息")
    @GetMapping("/userInfo")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    public Result<FullUserInfo> userInfo(){
        String username = UserContext.getUser().getUsername();
        FullUserInfo userInfo = sysUserService.findFullUserInfo(username);
        return Result.succeed(userInfo);
    }
    @ApiOperation("修改个人信息")
    @PostMapping("/userInfo/modify")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    public Result<String> modifyUserInfo(@RequestBody ModifyUserInfoModel model){
        model.setId(UserContext.getUserId());
        sysUserService.modifyUserInfo(model);
        return Result.succeed("ok");
    }
    @ApiOperation("获取收藏列表")
    @PostMapping("/myFavorite/list")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    public PageResult<SearchCourseResultModel> myFavoriteList(@RequestBody QueryFavoriteCourseModel model){
        return userCenterService.myFavoriteQueryPageList(model);
    }
    @ApiOperation("删除收藏")
    @PostMapping("/myFavorite/remove")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    @SysLog("删除收藏")
    public Result<String> removeFavorite(@RequestBody List<Long> courseIds){
        userCenterService.removeFavorite(courseIds);
        return Result.succeed("ok");
    }

    @ApiOperation("收藏课程")
    @PostMapping("/course/favorite")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    @SysLog("收藏课程")
    public Result<String> favoriteCourse(@RequestBody SaveFavoriteCourseModel model){
        userCenterService.favoriteCourse(model.getCourseId());
        return Result.succeed("ok");
    }
    @ApiOperation("取消收藏")
    @PostMapping("/course/removeFavorite")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    @SysLog("取消收藏")
    public Result<String> removeFavoriteCourse(@RequestBody SaveFavoriteCourseModel model){
        userCenterService.removeFavoriteCourse(model.getCourseId());
        return Result.succeed("ok");
    }


    @ApiOperation("获取视频播放凭证")
    @GetMapping("/course/playVideo")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    @SysLog("获取视频播放凭证")
    public Result<GetVideoPlayAuthResponse> getCoursePlayVideoUrl(@RequestParam Long courseId, @RequestParam Long chaperId){
        //验证权限
        userCenterService.checkCoursePlayPerm(courseId,chaperId);
        GetVideoPlayAuthResponse response = courseService.getVideoPlayAuth(courseId,chaperId);

        return Result.succeed(response);
    }


    @ApiOperation("已购课程列表")
    @PostMapping("/course/buy/list")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    public PageResult<BuyCourseListItem> buyCourseList(@RequestBody QueryBuyCourseListModel model){
        model.setUserId(UserContext.getUserId());
        return courseService.queryBuyCourseList(model);
    }
    @ApiOperation("用户购买记录列表")
    @PostMapping("/user/order/list")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    public PageResult<ProductOrderModel> userOrderList(@RequestBody QueryProductOrderModel model){
        model.setUsername(UserContext.getUser().getUsername());
        return orderService.queryPageList(model);
    }

}
