package com.qkdata.biz.management.controller;


import com.qkdata.biz.common.BizConstants;
import com.qkdata.biz.management.service.TeacherService;
import com.qkdata.biz.management.vo.QueryTeacherModel;
import com.qkdata.biz.management.vo.TeacherModel;
import com.qkdata.common.annotation.SysLog;
import com.qkdata.common.base.model.PageResult;
import com.qkdata.common.base.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * <p>
 * 讲师 前端控制器
 * </p>
 *
 * @author liuyang
 * @since 2021-05-18
 */
@Api(tags = "讲师管理")
@RestController
@RequestMapping("/api/mgr/teacher")
public class TeacherController {

    @Autowired
    private TeacherService teacherService;

    @ApiOperation("添加讲师信息")
    @PostMapping("/save")
    @SysLog(value = "添加讲师信息")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    public Result<String> save(@RequestBody @Validated TeacherModel model){
        teacherService.saveModel(model);
        return Result.succeed("ok");
    }
    @ApiOperation("修改讲师信息")
    @PostMapping("/update")
    @SysLog(value = "添加讲师信息")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    public Result<String> update(@RequestBody @Validated TeacherModel model){
        teacherService.updateModel(model);
        return Result.succeed("ok");
    }
    @ApiOperation("删除讲师信息")
    @PostMapping("/delete")
    @SysLog(value = "删除讲师信息")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    public Result<String> delete(@RequestBody List<Long> ids){
        teacherService.removeByIds(ids);
        return Result.succeed("ok");
    }
    @ApiOperation("查询讲师信息")
    @PostMapping("/list")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    public PageResult<TeacherModel> list(@RequestBody QueryTeacherModel param){

        return teacherService.queryPage(param);
    }


}
