package com.qkdata.biz.management.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.qkdata.biz.management.entity.OrgUserReceiveRecordPO;
import com.qkdata.biz.management.mapper.OrgUserReceiveRecordMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.qkdata.biz.web.vo.OrgUserReceiveRecordModel;
import com.qkdata.biz.web.vo.QueryReceiveHistoryModel;
import com.qkdata.common.base.enums.CodeEnum;
import com.qkdata.common.base.model.PageResult;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 企业成员领用或分配记录 服务类
 * </p>
 *
 * @author liuyang
 * @since 2021-06-03
 */
@Service
public class OrgUserReceiveRecordService extends ServiceImpl<OrgUserReceiveRecordMapper, OrgUserReceiveRecordPO> {

    public PageResult<OrgUserReceiveRecordModel> queryPageList(QueryReceiveHistoryModel model) {
        Page page = new Page(model.getPageIndex(),model.getPageSize());
        List<OrgUserReceiveRecordModel> list = baseMapper.queryPageList(page,model);
        return PageResult.<OrgUserReceiveRecordModel>builder().code(CodeEnum.SUCCESS.getCode()).count(page.getTotal()).data(list).build();
    }
}