package com.qkdata.biz.management.controller;

import com.qkdata.biz.management.service.OrganizationService;
import com.qkdata.biz.management.vo.EnterpriseListItemModel;
import com.qkdata.biz.management.vo.EnterpriseModel;
import com.qkdata.biz.management.vo.QueryEnterpriseModel;
import com.qkdata.common.annotation.SysLog;
import com.qkdata.common.base.model.PageResult;
import com.qkdata.common.base.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "企业管理")
@RestController
@RequestMapping("/api/mgr/enterprise")
public class EnterpriseController {

    @Autowired
    private OrganizationService orgService;

    @ApiOperation("企业列表查询")
    @PostMapping("/list")
    public PageResult<EnterpriseListItemModel> list(@RequestBody QueryEnterpriseModel param){
        return orgService.queryEnterprisePageList(param);
    }
    @ApiOperation("添加企业信息")
    @PostMapping("/save")
    @SysLog("添加企业信息")
    public Result<String> save(@RequestBody EnterpriseModel model){
        orgService.saveEnterprise(model);
        return Result.succeed("ok");
    }
    @ApiOperation("修改企业信息")
    @PostMapping("/update")
    @SysLog("修改企业信息")
    public Result<String> update(@RequestBody EnterpriseModel model){
        orgService.updateEnterprise(model);
        return Result.succeed("ok");
    }
}
