package com.qkdata.biz.sys.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.qkdata.biz.sys.entity.SysLogPO;
import com.qkdata.biz.sys.mapper.SysLogMapper;
import com.qkdata.biz.sys.vo.QueryLogModel;
import com.qkdata.common.base.enums.CodeEnum;
import com.qkdata.common.base.model.PageResult;
import com.qkdata.common.base.service.impl.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class SysLogService extends BaseServiceImpl<SysLogMapper, SysLogPO> {
    public PageResult<SysLogPO> queryPageList(QueryLogModel queryLogModel) {
        Page<SysLogPO> page = new Page<>(queryLogModel.getPageIndex(),queryLogModel.getPageSize());
        List<SysLogPO> pageList = baseMapper.queryPageList(page,queryLogModel);
        return PageResult.<SysLogPO>builder().code(CodeEnum.SUCCESS.getCode()).count(page.getTotal()).data(pageList).build();
    }
}
