package com.qkdata.biz.aliyun.controller;

import com.alibaba.fastjson.JSONObject;
import com.qkdata.biz.aliyun.service.AliyunService;
import com.qkdata.biz.aliyun.vo.AliyunCallbackRespModel;
import com.qkdata.biz.management.entity.ResourcePO;
import com.qkdata.biz.management.service.ResourceService;
import com.qkdata.common.annotation.SysLog;
import com.qkdata.common.base.model.Result;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@Api(tags = "阿里云OSS callback")
@RestController
@RequestMapping("/aliyun")
public class AliyunOSSCallbackController {

    @Autowired
    private AliyunService aliyunService;
    @Autowired
    private ResourceService resourceService;

    @SysLog("oss上传回调")
    @PostMapping("/oss/callback")
    public Result<JSONObject> callback(@RequestBody String callbackData){
        log.info(callbackData);
        AliyunCallbackRespModel model = JSONObject.parseObject(callbackData,AliyunCallbackRespModel.class);
        String url = aliyunService.generateUrl(model.getFileName());
        Long resourceId = saveToResource(model);
        JSONObject data = new JSONObject();
        data.put("ressourceId", resourceId);
        data.put("url",aliyunService.generateUrl(model.getFileName()));
        return Result.succeed(data);
    }

    private Long saveToResource(AliyunCallbackRespModel model) {
        ResourcePO po = new ResourcePO();
        po.setName(model.getFileName());
        po.setBucket(model.getBucket());
        po.setSize(model.getSize());
        resourceService.save(po);
        return po.getId();
    }
}
