package com.qkdata.biz.sys.controller;

import com.qkdata.biz.common.BizConstants;
import com.qkdata.biz.sys.entity.SysConfigPO;
import com.qkdata.biz.sys.service.SysConfigService;
import com.qkdata.biz.sys.vo.QueryConfigModel;
import com.qkdata.common.annotation.SysLog;
import com.qkdata.common.base.model.PageResult;
import com.qkdata.common.base.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

@Api(tags = "字典表")
@RestController
@RequestMapping("/api/sys/config")
public class SysConfigController {
    @Autowired
    private SysConfigService sysConfigService;

    @ApiOperation("查询列表")
    @PostMapping("/list")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    public PageResult<SysConfigPO> list(@RequestBody QueryConfigModel queryConfigModel){
        return sysConfigService.queryPageList(queryConfigModel);
    }

    @ApiOperation("获取单条信息")
    @GetMapping("/info/{id}")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    public Result<SysConfigPO> info(@PathVariable Long id){
        return Result.succeed(sysConfigService.getById(id));
    }

    @SysLog("保存字典数据")
    @ApiOperation("保存")
    @PostMapping("/save")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    public Result<String> save(@RequestBody SysConfigPO sysConfigPO){
        sysConfigService.save(sysConfigPO);
        return Result.succeed("ok");
    }

    @SysLog("修改字典数据")
    @ApiOperation("更新")
    @PostMapping("/update")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    public Result<String> update(@RequestBody SysConfigPO sysConfigPO){
        sysConfigService.updateById(sysConfigPO);
        return Result.succeed("ok");
    }

    @SysLog("删除字典数据")
    @ApiOperation("删除")
    @PostMapping("/delete")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    public Result<String> delete(@RequestBody Long[] ids){
        sysConfigService.removeByIds(Arrays.asList(ids));
        return Result.succeed("ok");
    }

}
