package com.qkdata.biz.management.service;

import com.qkdata.biz.enums.SwiperStatusEnum;
import com.qkdata.biz.management.entity.SwiperConfigPO;
import com.qkdata.biz.management.mapper.SwiperConfigMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.qkdata.biz.management.vo.SwiperConfigModel;
import com.qkdata.biz.management.vo.SwiperLInkCourseModel;
import com.qkdata.biz.management.vo.SwiperModifyStatusModel;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * $!{table.comment} 服务类
 * </p>
 *
 * @author liuyang
 * @since 2021-05-27
 */
@Service
public class SwiperConfigService extends ServiceImpl<SwiperConfigMapper, SwiperConfigPO> {

    public List<SwiperConfigModel> listConfig(SwiperStatusEnum status) {
        return baseMapper.listConfig(status);
    }

    public void linkCourse(SwiperLInkCourseModel model) {
        SwiperConfigPO po = new SwiperConfigPO();
        po.setCourseId(model.getCourseId());
        po.setId(model.getId());
        updateById(po);
    }

    public void modifyStatus(SwiperModifyStatusModel model) {
        SwiperConfigPO po = new SwiperConfigPO();
        po.setId(model.getId());
        po.setStatus(model.getStatus());
        updateById(po);
    }
}