package com.qkdata.biz.web.controller;

import com.qkdata.biz.common.BizConstants;
import com.qkdata.biz.sys.service.SysUserService;
import com.qkdata.biz.web.service.UserCenterService;
import com.qkdata.biz.web.vo.FullUserInfo;
import com.qkdata.biz.web.vo.SearchCourseResultModel;
import com.qkdata.common.annotation.SysLog;
import com.qkdata.common.base.model.PageResult;
import com.qkdata.common.base.model.Result;
import com.qkdata.common.util.UserContext;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Api(tags = "我的相关数据接口")
@RestController
@RequestMapping("/api/userCenter")
public class UserCenterController {
    @Autowired
    private UserCenterService userCenterService;
    @Autowired
    private SysUserService sysUserService;

    @ApiOperation("获取个人信息")
    @GetMapping("/userInfo")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    public Result<FullUserInfo> userInfo(){
        String username = UserContext.getUser().getUsername();
        FullUserInfo userInfo = sysUserService.findFullUserInfo(username);
        return Result.succeed(userInfo);
    }
    @ApiOperation("获取收藏列表")
    @GetMapping("/myFavorite/list")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    public PageResult<SearchCourseResultModel> myFavoriteList(){
        return userCenterService.myFavoriteQueryPageList();
    }
    @ApiOperation("删除收藏")
    @PostMapping("/myFavorite/remove")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    @SysLog("删除收藏")
    public Result<String> removeFavorite(@RequestBody List<Long> courseIds){
        userCenterService.removeFavorite(courseIds);
        return Result.succeed("ok");
    }

}
