package com.qkdata.biz.management.vo;

import com.qkdata.biz.enums.AccountStatusEnum;
import com.qkdata.biz.enums.AccountTypeEnum;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

@Data
public class MemberInfoModel {
    /**
     * ID
     */
    private Long id;
    /**
     * 手机号
     */
    private String username;
    /**
     * 密码
     */
    private String password;
    /**
     * 昵称
     */
    private String nickName;
    /**
     * 最后登录时间
     */
    private LocalDateTime lastLoginTime;
    /**
     * 激活时间
     */
    private LocalDateTime activateTime;
    /**
     * 帐号状态
     */
    private AccountStatusEnum status;
    /**
     * 注册时间
     */
    private LocalDateTime createTime;
    /**
     * 姓名
     */
    private String name;

    /**
     * 性别
     */
    private String sex;

    /**
     * 年龄
     */
    private Integer age;

    /**
     * 头像url
     */
    private String avatarUrl;

    /**
     * 用户类型（普通用户、会员、企业会员）
     */
    private AccountTypeEnum type;

    /**
     * 企业ID
     */
    private Long enterpriseId;
    /**
     * 所属企业名称
     */
    private String enterpriseName;

    /**
     * 会员生效时间
     */
    private LocalDateTime vipStartTime;

    /**
     * 会员结束时间
     */
    private LocalDateTime vipEndTime;
    /**
     * 角色编码列表
     */
    private List<String> roleCodeList;
}
