package com.qkdata.biz.web.controller;

import com.qkdata.biz.common.BizConstants;
import com.qkdata.biz.enums.PaySourceEnum;
import com.qkdata.biz.enums.ProductOrderStatusEnum;
import com.qkdata.biz.enums.ProductTypeEnum;
import com.qkdata.biz.management.entity.CoursePO;
import com.qkdata.biz.management.service.CourseService;
import com.qkdata.biz.management.service.ProductOrderService;
import com.qkdata.biz.web.vo.CreateOrderModel;
import com.qkdata.biz.web.vo.CreateOrderResult;
import com.qkdata.common.base.exception.BusinessException;
import com.qkdata.common.base.model.Result;
import com.qkdata.common.util.UserContext;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@Api(tags = "用户下单处理-手机端")
@RestController
@RequestMapping("/api/productOrder")
public class FrontendProductOrderController {
    @Autowired
    private ProductOrderService orderService;
    @Autowired
    private CourseService courseService;

    @ApiOperation("购买时新建订单")
    @PostMapping("/createOrder")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    public Result<CreateOrderResult> createOrder(@RequestBody CreateOrderModel model){
        model.setUserId(UserContext.getUserId());
        model.setUsername(UserContext.getUser().getUsername());
        if (model.getProductType() == ProductTypeEnum.ENTERPRISE_COURSE_BUY || model.getProductType() == ProductTypeEnum.COURSE_BUY){
            if (model.getCourseId() == null){
                throw new BusinessException("请求错误，课程ID不能为空");
            }
            CoursePO coursePO = courseService.getById(model.getCourseId());
            if (coursePO == null){
                throw new BusinessException("请求错误，课程不存在");
            }
        }
        if (model.getCount() <= 0){
            throw new BusinessException("请求错误，购买数量不能为0");
        }
        CreateOrderResult result = orderService.createOrder(model);
        return Result.succeed(result);
    }
    @ApiOperation("查询订单状态")
    @GetMapping("/user/queryOrderStatus")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    public Result<ProductOrderStatusEnum> queryOrderStatus(@RequestParam String orderNo){
        ProductOrderStatusEnum status = orderService.queryStatus(orderNo);
        return Result.succeed(status);
    }
    @ApiOperation("重新支付")
    @PostMapping("/payAgain")
    @RequiresRoles(value = {BizConstants.ROLE_USER,BizConstants.ROLE_ENTERPRISE_ADMIN},logical = Logical.OR)
    public Result<CreateOrderResult> payAgain(@RequestParam String orderNo, @RequestParam PaySourceEnum source){
        CreateOrderResult result = orderService.payAgain(orderNo,source);
        return Result.succeed(result);
    }
}
