package com.qkdata.biz.management.service;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.qkdata.biz.enums.ProductTypeEnum;
import com.qkdata.biz.management.entity.OrgSurplusPO;
import com.qkdata.biz.management.mapper.OrgSurplusMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.qkdata.biz.web.vo.OrgCourseSurplusModel;
import com.qkdata.biz.web.vo.QueryOrgCourseSurplusModel;
import com.qkdata.common.base.enums.CodeEnum;
import com.qkdata.common.base.exception.BusinessException;
import com.qkdata.common.base.model.PageResult;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 企业VIP或课程余额 服务类
 * </p>
 *
 * @author liuyang
 * @since 2021-06-03
 */
@Service
public class OrgSurplusService extends ServiceImpl<OrgSurplusMapper, OrgSurplusPO> {

    /**
     * 更新企业VIP或课程余额
     * @param orgId
     * @param courseId
     * @param productType
     * @param count
     */
    public void updateSurplus(Long orgId, Long courseId, ProductTypeEnum productType,Integer count) {
        OrgSurplusPO po = null;
        if (productType == ProductTypeEnum.ENTERPRISE_VIP){
            po = getOne(Wrappers.<OrgSurplusPO>lambdaQuery().eq(OrgSurplusPO::getOrgId,orgId).eq(OrgSurplusPO::getProductType,productType));
        }else if (productType == ProductTypeEnum.ENTERPRISE_COURSE_BUY){
            po = getOne(Wrappers.<OrgSurplusPO>lambdaQuery().eq(OrgSurplusPO::getOrgId,orgId).eq(OrgSurplusPO::getCourseId,courseId).eq(OrgSurplusPO::getProductType,productType));
        }
        if (po == null){
            po = new OrgSurplusPO();
            po.setOrgId(orgId);
            po.setCourseId(courseId);
            po.setProductType(productType);
            po.setCount(count);
            save(po);
        }else {
            po.setCount(po.getCount()+count);
            updateById(po);
        }
    }

    /**
     * 查询企业课程余额列表
     * @param model
     * @return
     */
    public PageResult<OrgCourseSurplusModel> queryCourseSurplusPageList(QueryOrgCourseSurplusModel model) {
        Page page = new Page(model.getPageIndex(),model.getPageSize());
        List<OrgCourseSurplusModel> list = baseMapper.queryCourseSurplusPageList(page,model);
        return PageResult.<OrgCourseSurplusModel>builder().code(CodeEnum.SUCCESS.getCode()).count(page.getTotal()).data(list).build();
    }

    /**
     * 减少企业购买的余额
     * @param po
     */
    public void subtractCount(OrgSurplusPO po) {
        OrgSurplusPO dbPo = null;
        if (po.getProductType() == ProductTypeEnum.ENTERPRISE_VIP){
            dbPo = getOne(Wrappers.<OrgSurplusPO>lambdaQuery().eq(OrgSurplusPO::getOrgId,po.getOrgId()).eq(OrgSurplusPO::getProductType,po.getProductType()));
        }else if (po.getProductType() == ProductTypeEnum.ENTERPRISE_COURSE_BUY){
            dbPo = getOne(Wrappers.<OrgSurplusPO>lambdaQuery().eq(OrgSurplusPO::getOrgId,po.getOrgId()).eq(OrgSurplusPO::getCourseId,po.getCourseId()).eq(OrgSurplusPO::getProductType,po.getProductType()));
        }
        if (dbPo == null){
            throw new BusinessException("请求错误，数据不存在");
        }else {
            int dbCount = dbPo.getCount();
            int newCount = dbCount - po.getCount();
            if (newCount < 0){
                throw new BusinessException("企业余额不足，不能领用");
            }
            dbPo.setCount(newCount);
            updateById(dbPo);

        }
    }
}