
-- ----------------------------
-- Table structure for allow_org_course
-- ----------------------------
DROP TABLE IF EXISTS `allow_org_course`;
CREATE TABLE `allow_org_course` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `course_id` bigint(20) DEFAULT NULL COMMENT '课程ID',
  `org_id` bigint(20) DEFAULT NULL COMMENT '企业ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='授权企业可见的课程';


-- ----------------------------
-- Table structure for course
-- ----------------------------
DROP TABLE IF EXISTS `course`;
CREATE TABLE `course` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `type` varchar(20) DEFAULT NULL COMMENT '课程类型（单集、系列）',
  `name` varchar(255) DEFAULT NULL COMMENT '课程名称',
  `introduce` text COMMENT '课程简介',
  `logo_url` varchar(255) DEFAULT NULL COMMENT '课程封面url',
  `status` varchar(10) DEFAULT NULL COMMENT '状态（上架、下架）',
  `teacher_id` bigint(20) DEFAULT NULL COMMENT '讲师ID',
  `charge_model` varchar(20) DEFAULT NULL COMMENT '收费模式（免费、会员免费、付费点播）',
  `price` decimal(10,2) DEFAULT NULL COMMENT '付费点播普通用户价',
  `vip_price` decimal(10,2) DEFAULT NULL COMMENT '付费点播会员价',
  `valid_period` int(10) DEFAULT NULL COMMENT '有效时间（小时）',
  `model` varchar(20) DEFAULT NULL COMMENT '课程形态（点播、直播、一对一）',
  `series_id` bigint(20) DEFAULT NULL COMMENT '系列ID',
  `allow` varchar(10) DEFAULT NULL COMMENT '可见范围（全部、指定企业）',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `is_del` tinyint(1) DEFAULT 0 COMMENT '删除标识',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='课程';


-- ----------------------------
-- Table structure for course_chapter
-- ----------------------------
DROP TABLE IF EXISTS `course_chapter`;
CREATE TABLE `course_chapter` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `course_id` bigint(20) DEFAULT NULL COMMENT '课程ID',
  `resource_id` bigint(20) DEFAULT NULL COMMENT '视频ID',
  `name` varchar(255) DEFAULT NULL COMMENT '章节标题',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='课程章节';


-- ----------------------------
-- Table structure for course_consume_record
-- ----------------------------
DROP TABLE IF EXISTS `course_consume_record`;
CREATE TABLE `course_consume_record` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `user_id` bigint(20) DEFAULT NULL COMMENT '用户ID',
  `watch_time` bigint(20) DEFAULT NULL COMMENT '观看时长（分钟）',
  `course_id` bigint(20) DEFAULT NULL COMMENT '课程ID',
  `chapter_id` bigint(20) DEFAULT NULL COMMENT '章节ID',
  `video_id` bigint(20) DEFAULT NULL COMMENT '视频ID',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='课程消耗记录';


-- ----------------------------
-- Table structure for course_series
-- ----------------------------
DROP TABLE IF EXISTS `course_series`;
CREATE TABLE `course_series` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(255) DEFAULT NULL COMMENT '系列名称',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='课程系列';


-- ----------------------------
-- Table structure for course_tag
-- ----------------------------
DROP TABLE IF EXISTS `course_tag`;
CREATE TABLE `course_tag` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(255) DEFAULT NULL COMMENT '名称',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='课程标签';


-- ----------------------------
-- Table structure for course_tag_rel
-- ----------------------------
DROP TABLE IF EXISTS `course_tag_rel`;
CREATE TABLE `course_tag_rel` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `course_id` bigint(20) DEFAULT NULL COMMENT '课程ID',
  `tag_id` bigint(20) DEFAULT NULL COMMENT '标签ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='课程与标签关联表';


-- ----------------------------
-- Table structure for exam
-- ----------------------------
DROP TABLE IF EXISTS `exam`;
CREATE TABLE `exam` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(255) DEFAULT NULL COMMENT '考试名称',
  `limit` int(11) DEFAULT NULL COMMENT '考试限时（分钟）',
  `description` varchar(255) DEFAULT NULL COMMENT '考试简述',
  `question_ids_radio` varchar(512) DEFAULT NULL COMMENT '单选题ID集合，以逗号分隔',
  `question_ids_check` varchar(512) DEFAULT NULL COMMENT '多选题ID集合，以逗号分隔',
  `question_ids_judge` varchar(512) DEFAULT NULL COMMENT '判断题ID集合，以逗号分隔',
  `score_radio` int(11) DEFAULT NULL COMMENT '当前考试每个单选题的分数',
  `score_check` int(11) DEFAULT NULL COMMENT '当前考试每个多选题的分数',
  `score_judge` int(11) DEFAULT NULL COMMENT '当前考试每个判断题的分数',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='考试信息';


-- ----------------------------
-- Table structure for exam_question
-- ----------------------------
DROP TABLE IF EXISTS `exam_question`;
CREATE TABLE `exam_question` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` text COMMENT '题目名称',
  `type` varchar(20) DEFAULT NULL COMMENT '题目类型（单选、多选、判断）',
  `option_ids` varchar(255) DEFAULT NULL COMMENT '选项ID集合，以逗号分隔',
  `answer_ids` varchar(255) DEFAULT NULL COMMENT '签案ID集合，以逗号分隔',
  `description` text COMMENT '题目解析',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='题目信息';


-- ----------------------------
-- Table structure for exam_question_option
-- ----------------------------
DROP TABLE IF EXISTS `exam_question_option`;
CREATE TABLE `exam_question_option` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `选项内容` text COMMENT '选项内容',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='题目选项';


-- ----------------------------
-- Table structure for exam_record
-- ----------------------------
DROP TABLE IF EXISTS `exam_record`;
CREATE TABLE `exam_record` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `user_id` bigint(20) DEFAULT NULL COMMENT '用户ID',
  `exam_id` bigint(20) DEFAULT NULL COMMENT '考试ID',
  `start_time` datetime DEFAULT NULL COMMENT '考试时间',
  `end_time` datetime DEFAULT NULL COMMENT '完成时间',
  `score` int(11) DEFAULT NULL COMMENT '得分',
  `answer_ids` varchar(512) DEFAULT NULL COMMENT '答案ID集合，以逗号分隔',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='考试记录';


-- ----------------------------
-- Table structure for org_buy_course_record
-- ----------------------------
DROP TABLE IF EXISTS `org_buy_course_record`;
CREATE TABLE `org_buy_course_record` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `org_id` bigint(20) DEFAULT NULL COMMENT '企业ID',
  `course_id` bigint(20) DEFAULT NULL COMMENT '课程ID',
  `count` int(10) DEFAULT NULL COMMENT '剩余份数',
  `open` tinyint(1) DEFAULT NULL COMMENT '是否开放成员领取',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='企业购买会员记录';


-- ----------------------------
-- Table structure for org_buy_vip_record
-- ----------------------------
DROP TABLE IF EXISTS `org_buy_vip_record`;
CREATE TABLE `org_buy_vip_record` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `org_id` bigint(20) DEFAULT NULL COMMENT '企业ID',
  `vip_count` int(11) DEFAULT NULL COMMENT '会员剩余个数',
  `open` tinyint(1) DEFAULT NULL COMMENT '是否开放成员领取',
  `limit` int(10) DEFAULT NULL COMMENT '限制领取时长',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='企业购买会员记录';


-- ----------------------------
-- Table structure for organization
-- ----------------------------
DROP TABLE IF EXISTS `organization`;
CREATE TABLE `organization` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(100) DEFAULT NULL COMMENT '组织名称',
  `type` varchar(20) DEFAULT NULL COMMENT '组织类型（企业、培训机构）',
  `contact_tel` varchar(20) DEFAULT NULL COMMENT '联系人电话',
  `contact_name` varchar(20) DEFAULT NULL COMMENT '联系人名称',
  `logo_url` varchar(1000) DEFAULT NULL COMMENT '企业LOG',
  `province` varchar(255) DEFAULT NULL COMMENT '省份',
  `city` varchar(255) DEFAULT NULL COMMENT '城市',
  `address` varchar(1000) DEFAULT NULL COMMENT '详细地址',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `is_del` tinyint(1) DEFAULT 0 COMMENT '删除标识',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='组织';


-- ----------------------------
-- Table structure for recommend_config
-- ----------------------------
DROP TABLE IF EXISTS `recommend_config`;
CREATE TABLE `recommend_config` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `course_id` bigint(20) DEFAULT NULL COMMENT '课程ID',
  `sort_no` int(11) DEFAULT NULL COMMENT '排序号',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='推荐课程配置';


-- ----------------------------
-- Table structure for resource
-- ----------------------------
DROP TABLE IF EXISTS `resource`;
CREATE TABLE `resource` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(255) DEFAULT NULL COMMENT '名称',
  `bucket` varchar(255) DEFAULT NULL COMMENT 'bucket名称',
  `size` bigint(20) DEFAULT NULL COMMENT '资源大小',
  `url` varchar(255) DEFAULT NULL COMMENT '访问url',
  `video_duration` float DEFAULT NULL COMMENT '视频时长',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='资源';



-- ----------------------------
-- Table structure for swiper_config
-- ----------------------------
DROP TABLE IF EXISTS `swiper_config`;
CREATE TABLE `swiper_config` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `image_url` varchar(1000) DEFAULT NULL COMMENT '封面图片url',
  `course_id` bigint(20) DEFAULT NULL COMMENT '课程ID',
  `sort_no` int(11) DEFAULT NULL COMMENT '排序号',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='轮播图配置';


-- ----------------------------
-- Table structure for sys_log
-- ----------------------------
DROP TABLE IF EXISTS `sys_log`;
CREATE TABLE `sys_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `username` varchar(20) DEFAULT NULL COMMENT '用户名',
  `operation` varchar(255) DEFAULT NULL COMMENT '用户操作',
  `method` varchar(255) DEFAULT NULL COMMENT '请求方法',
  `params` text COMMENT '请求参数',
  `time` bigint(20) DEFAULT NULL COMMENT '执行时长(毫秒)',
  `ip` varchar(64) DEFAULT NULL COMMENT 'IP地址',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='系统操作日志';

-- ----------------------------
-- Table structure for sys_menu
-- ----------------------------
DROP TABLE IF EXISTS `sys_menu`;
CREATE TABLE `sys_menu` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `parent_id` bigint(20) DEFAULT NULL COMMENT '父菜单ID，一级菜单为0',
  `name` varchar(50) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '菜单名称',
  `url` varchar(200) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '菜单URL',
  `perms` varchar(500) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '授权(多个用逗号分隔，如：user:list,user:create)',
  `type` int(11) DEFAULT NULL COMMENT '类型   0：目录   1：菜单   2：按钮',
  `icon` varchar(50) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '菜单图标',
  `order_num` int(11) DEFAULT NULL COMMENT '排序',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin ROW_FORMAT=DYNAMIC COMMENT='菜单管理';


-- ----------------------------
-- Table structure for sys_role
-- ----------------------------
DROP TABLE IF EXISTS `sys_role`;
CREATE TABLE `sys_role` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `code` varchar(20) DEFAULT NULL COMMENT '角色代码',
  `name` varchar(100) DEFAULT NULL COMMENT '角色名称',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COMMENT='角色表';

-- ----------------------------
-- Records of sys_role
-- ----------------------------
INSERT INTO `sys_role` VALUES (1, 'ADMIN', '系统管理员', '2021-04-25 16:10:06', '2021-04-25 16:10:06');
INSERT INTO `sys_role` VALUES (2, 'OPERATOR', '运营人员', '2021-04-25 16:10:06', '2021-04-25 16:10:06');
INSERT INTO `sys_role` VALUES (3, 'ENTERPRISE_ADMIN', '企业管理员', '2021-04-25 16:10:06', '2021-04-25 16:10:06');
INSERT INTO `sys_role` VALUES (4, 'INSTITUTION_ADMIN', '培训机构管理员', '2021-04-25 16:10:06', '2021-04-25 16:10:06');
INSERT INTO `sys_role` VALUES (5, 'USER', '普通用户', '2021-04-25 16:10:06', '2021-04-25 16:10:06');

-- ----------------------------
-- Table structure for sys_role_menu
-- ----------------------------
DROP TABLE IF EXISTS `sys_role_menu`;
CREATE TABLE `sys_role_menu` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `role_id` bigint(20) DEFAULT NULL COMMENT '角色ID',
  `menu_id` bigint(20) DEFAULT NULL COMMENT '菜单ID',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin ROW_FORMAT=DYNAMIC COMMENT='角色与菜单对应关系';


-- ----------------------------
-- Table structure for sys_config
-- ----------------------------
DROP TABLE IF EXISTS `sys_config`;
CREATE TABLE `sys_config` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `param_key` varchar(50) COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'key',
  `param_value` varchar(2000) COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'value',
  `status` int(4) DEFAULT '1' COMMENT '状态   0：隐藏   1：显示',
  `remark` varchar(500) COLLATE utf8mb4_bin DEFAULT NULL COMMENT '备注',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `param_key` (`param_key`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin ROW_FORMAT=DYNAMIC COMMENT='系统配置信息表';

-- ----------------------------
-- Table structure for sys_user
-- ----------------------------
DROP TABLE IF EXISTS `sys_user`;
CREATE TABLE `sys_user` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `username` varchar(20) NOT NULL COMMENT '手机号',
  `password` varchar(100) DEFAULT NULL COMMENT '密码',
  `salt` varchar(20) DEFAULT NULL COMMENT '盐',
  `nick_name` varchar(50) DEFAULT NULL COMMENT '昵称',
  `status` int(1) DEFAULT NULL COMMENT '状态',
  `create_time` datetime DEFAULT NULL COMMENT '注册时间',
  `last_login_time` datetime DEFAULT NULL COMMENT '最后登录时间',
  `activate_time` datetime DEFAULT NULL COMMENT '激活时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `is_del` tinyint(1) DEFAULT 0 COMMENT '删除标识',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COMMENT='用户表';

-- ----------------------------
-- Records of sys_user
-- ----------------------------
INSERT INTO `sys_user` VALUES (1, 'admin', 'cdac762d0ba79875489f6a8b430fa8b5dfe0cdd81da38b80f02f33328af7fd4a', 'YzcmCZNvbXocrsz9dm8e', '系管理员', 1, '2021-04-25 16:10:06', NULL, NULL, '2021-04-25 16:10:06', 0);

-- ----------------------------
-- Table structure for sys_user_role
-- ----------------------------
DROP TABLE IF EXISTS `sys_user_role`;
CREATE TABLE `sys_user_role` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `user_id` bigint(20) NOT NULL COMMENT '用户ID',
  `role_id` bigint(20) NOT NULL COMMENT '角色ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COMMENT='用户角色关联表';

INSERT INTO `sys_user_role` VALUES (1,1,1);

-- ----------------------------
-- Table structure for teacher
-- ----------------------------
DROP TABLE IF EXISTS `teacher`;
CREATE TABLE `teacher` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `code` varchar(100) DEFAULT NULL COMMENT '编号',
  `name` varchar(20) DEFAULT NULL COMMENT '姓名',
  `mobile` varchar(20) DEFAULT NULL COMMENT '电话',
  `org_id` bigint(20) DEFAULT NULL COMMENT '所属机构ID',
  `introduce` text COMMENT '简介',
  `avatar_url` varchar(1000) DEFAULT NULL COMMENT '头像',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `is_del` tinyint(1) DEFAULT 0 COMMENT '删除标识',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='讲师';


-- ----------------------------
-- Table structure for user_ext
-- ----------------------------
DROP TABLE IF EXISTS `user_ext`;
CREATE TABLE `user_ext` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `user_id` bigint(20) DEFAULT NULL COMMENT '用户ID',
  `name` varchar(20) DEFAULT NULL COMMENT '姓名',
  `sex` varchar(10) DEFAULT NULL COMMENT '性别',
  `age` int(10) DEFAULT NULL COMMENT '年龄',
  `avatar_url` varchar(1000) DEFAULT NULL COMMENT '头像url',
  `type` varchar(20) DEFAULT NULL COMMENT '用户类型（普通用户、会员、企业会员）',
  `enterprise_id` bigint(20) DEFAULT NULL COMMENT '企业ID',
  `vip_start_time` datetime DEFAULT NULL COMMENT '会员生效时间',
  `vip_end_time` datetime DEFAULT NULL COMMENT '会员结束时间',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COMMENT='用户扩展表';


-- ----------------------------
-- Table structure for user_favorites
-- ----------------------------
DROP TABLE IF EXISTS `user_favorites`;
CREATE TABLE `user_favorites` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `user_id` bigint(10) DEFAULT NULL COMMENT '用户ID',
  `course_id` bigint(20) DEFAULT NULL COMMENT '课程ID',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='用户收藏课程';


-- ----------------------------
-- Table structure for user_get_vip_record
-- ----------------------------
DROP TABLE IF EXISTS `user_get_vip_record`;
CREATE TABLE `user_get_vip_record` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `create_time` datetime DEFAULT NULL COMMENT '领取时间',
  `update_time` datetime DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL COMMENT '用户ID',
  `type` varchar(20) DEFAULT NULL COMMENT '领取类型（月卡、付费点播课程）',
  `course_id` bigint(20) DEFAULT NULL COMMENT '课程ID',
  `org_id` bigint(20) DEFAULT NULL COMMENT '企业ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='企业会员领取记录';

