package com.qkdata.biz.sys.controller;

import com.qkdata.biz.common.BizConstants;
import com.qkdata.biz.sys.entity.SysMenuPO;
import com.qkdata.biz.sys.service.ShiroService;
import com.qkdata.biz.sys.service.SysMenuService;
import com.qkdata.biz.sys.vo.SysNavModel;
import com.qkdata.common.annotation.SysLog;
import com.qkdata.common.base.exception.BusinessException;
import com.qkdata.common.base.model.Result;
import com.qkdata.common.util.UserContext;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Set;

@Api(tags = "菜单管理")
@RestController
@RequestMapping("/api/sys/menu")
public class SysMenuController {
    @Autowired
    private SysMenuService sysMenuService;
    @Autowired
    private ShiroService shiroService;

    @ApiOperation("获取当前用户的菜单")
    @GetMapping("/nav")
    public Result<SysNavModel> nav(){
        List<SysMenuPO> menuList = sysMenuService.getUserMenuList(UserContext.getUserId());
        Set<String> permissions = shiroService.getUserPermissions(UserContext.getUserId());
        SysNavModel navDTO = new SysNavModel(menuList,permissions);
        return Result.succeed(navDTO);
    }
    @ApiOperation("获取全部菜单列表")
    @GetMapping("/list")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    public Result<List<SysMenuPO>> list(){
        List<SysMenuPO> menuList = sysMenuService.list();
        for (SysMenuPO menuPO : menuList){
            SysMenuPO parentMenu = sysMenuService.getById(menuPO.getParentId());
            if (parentMenu != null){
                menuPO.setParentName(parentMenu.getName());
            }
        }
        return Result.succeed(menuList);
    }

    @ApiOperation("获取不包含按扭的全部菜单")
    @GetMapping("/select")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    public Result<List<SysMenuPO>> select(){
        List<SysMenuPO> menuList = sysMenuService.queryNotButtonList();

        //添加顶级菜单
        SysMenuPO root = new SysMenuPO();
        root.setId(0L);
        root.setName("一级菜单");
        root.setParentId(-1L);
        root.setOpen(true);
        menuList.add(root);

        return Result.succeed(menuList);
    }

    @ApiOperation("获取单个菜单详细信息")
    @GetMapping("/info/{id}")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    public Result<SysMenuPO> info(@PathVariable Long id){
        SysMenuPO sysMenuPO = sysMenuService.getById(id);
        return Result.succeed(sysMenuPO);
    }

    @ApiOperation("保存菜单信息")
    @SysLog("保存菜单信息")
    @PostMapping("/save")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    public Result<String> save(@RequestBody SysMenuPO sysMenuPO){
        sysMenuService.save(sysMenuPO);
        return Result.succeed("ok");
    }
    @ApiOperation("修改菜单信息")
    @SysLog("修改菜单信息")
    @PostMapping("/update")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    public Result<String> update(@RequestBody SysMenuPO sysMenuPO){
        sysMenuService.updateById(sysMenuPO);
        return Result.succeed("ok");
    }
    @ApiOperation("删除菜单")
    @SysLog("删除菜单")
    @GetMapping("/delete/{id}")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR},logical = Logical.OR)
    public Result<String> delete(@PathVariable Long id){
        if (id <= 31){
            throw new BusinessException("系统菜单不能删除");
        }
        //判断是否有子菜单或按钮
        List<SysMenuPO> menuList = sysMenuService.queryListParentId(id);
        if(menuList.size() > 0){
            throw new BusinessException("请先删除子菜单或按钮");
        }
        sysMenuService.removeById(id);
        return Result.succeed("ok");
    }
}
