package com.qkdata.biz.management.service;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.qkdata.biz.management.entity.CoursePO;
import com.qkdata.biz.management.entity.CourseTagPO;
import com.qkdata.biz.management.mapper.*;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.qkdata.biz.management.vo.CourseListItemModel;
import com.qkdata.biz.management.vo.QueryCourseModel;
import com.qkdata.common.base.enums.CodeEnum;
import com.qkdata.common.base.model.PageResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 课程管理 服务类
 * </p>
 *
 * @author liuyang
 * @since 2021-05-19
 */
@Service
public class CourseService extends ServiceImpl<CourseMapper, CoursePO> {
    @Autowired
    private AllowOrgCourseMapper allowOrgCourseMapper;
    @Autowired
    private CourseChapterMapper chapterMapper;
    @Autowired
    private CourseSeriesMapper seriesMapper;
    @Autowired
    private CourseTagRelMapper tagRelMapper;
    @Autowired
    private CourseTagService tagService;

    public PageResult<CourseListItemModel> queryPageList(QueryCourseModel param) {
        Page page = new Page(param.getPageIndex(),param.getPageSize());
        List<CourseListItemModel> list = baseMapper.queryPageList(page,param);
        for (CourseListItemModel course : list){
            List<CourseTagPO> tagsList = tagService.findListByCourseId(course.getId());
            if (CollUtil.isNotEmpty(tagsList)){
                List<String> tagNameList = tagsList.stream().map(CourseTagPO::getName).collect(Collectors.toList());
                course.setTags(tagNameList);
            }
        }
        return PageResult.<CourseListItemModel>builder().code(CodeEnum.SUCCESS.getCode()).count(page.getTotal()).data(list).build();
    }
}