package com.qkdata.biz.management.controller;


import com.qkdata.biz.management.service.CourseService;
import com.qkdata.biz.management.vo.CourseListItemModel;
import com.qkdata.biz.management.vo.QueryCourseModel;
import com.qkdata.common.base.model.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 课程 前端控制器
 * </p>
 *
 * @author liuyang
 * @since 2021-05-19
 */
@Api(tags = "课程管理")
@RestController
@RequestMapping("/api/mgr/course")
public class CourseController {

    @Autowired
    private CourseService courseService;

    @ApiOperation("课程查询")
    @PostMapping("/list")
    public PageResult<CourseListItemModel> list(@RequestBody QueryCourseModel param){

        return courseService.queryPageList(param);
    }
}
