package com.qkdata.biz.management.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.binarywang.wxpay.bean.order.WxPayMpOrderResult;
import com.github.binarywang.wxpay.bean.order.WxPayMwebOrderResult;
import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import com.github.binarywang.wxpay.bean.result.WxPayOrderQueryResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import com.qkdata.biz.common.BizConstants;
import com.qkdata.biz.enums.*;
import com.qkdata.biz.management.entity.CoursePO;
import com.qkdata.biz.management.entity.ProductOrderPO;
import com.qkdata.biz.management.entity.UserCourseAuthPO;
import com.qkdata.biz.management.mapper.ProductOrderMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.qkdata.biz.management.vo.ProductOrderModel;
import com.qkdata.biz.management.vo.QueryProductOrderModel;
import com.qkdata.biz.sys.entity.SysUserPO;
import com.qkdata.biz.sys.service.SysConfigService;
import com.qkdata.biz.sys.service.SysRoleService;
import com.qkdata.biz.sys.service.SysUserService;
import com.qkdata.biz.sys.vo.SysRoleModel;
import com.qkdata.biz.web.vo.CreateOrderResult;
import com.qkdata.biz.web.vo.FullUserInfo;
import com.qkdata.biz.web.vo.UserBuyVIPModel;
import com.qkdata.common.base.enums.CodeEnum;
import com.qkdata.common.base.exception.BusinessException;
import com.qkdata.common.base.model.PageResult;
import com.qkdata.common.util.HttpContextUtils;
import com.qkdata.common.util.IPUtils;
import com.qkdata.common.util.UserContext;
import com.qkdata.wx.pay.config.WxPayProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.sql.DataSource;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 产品订单 服务类
 * </p>
 *
 * @author liuyang
 * @since 2021-06-02
 */
@Service
public class ProductOrderService extends ServiceImpl<ProductOrderMapper, ProductOrderPO> {

    @Autowired
    private WxPayService wxService;
    @Autowired
    private CourseService courseService;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private SysUserService sysUserService;
    @Value("${frontend.domain}")
    private String frontendDomain;
    @Autowired
    private SysRoleService roleService;
    @Autowired
    private UserCourseAuthService userCourseAuthService;
    @Autowired
    private OrgSurplusService orgSurplusService;


    public void createOrder(UserBuyVIPModel model) {


    }

    private String generateOrderNo() {
        DateTime nowDateTime = DateUtil.date();
        String dateStr = DateUtil.format(nowDateTime,"yyyyMMddHHmmssSSS");
        return dateStr + RandomUtil.randomNumbers(4);
    }

    private <T> T wxCreateOrder(ProductOrderPO order, PaySourceEnum source) throws WxPayException {
        WxPayUnifiedOrderRequest payRequest = new WxPayUnifiedOrderRequest();
        if(wxService.getConfig().isUseSandboxEnv()){
            String key = wxService.getSandboxSignKey();
            wxService.getConfig().setMchKey(key);
        }
        payRequest.setNonceStr(RandomUtil.randomString(32));
        payRequest.setBody(StrUtil.format("在线培训网站-{}",order.getOrderName()));
        payRequest.setOutTradeNo(order.getOrderNo());
        //金额元转为分
        BigDecimal fee = order.getPaymentMoney().multiply(new BigDecimal(100));
        if (wxService.getConfig().isUseSandboxEnv()){
//            payRequest.setTotalFee(101);//成功用例
            payRequest.setTotalFee(102);//失败用例
        }else {
            payRequest.setTotalFee(fee.intValue());
        }
        payRequest.setSpbillCreateIp(IPUtils.getIpAddr(HttpContextUtils.getHttpServletRequest()));
        payRequest.setNotifyUrl(StrUtil.format("{}{}",frontendDomain,"/online-edu-backend/wx/pay/notify/order"));
        payRequest.setTradeType(source.name());
        return wxService.createOrder(payRequest);
    }

    public CreateOrderResult userBuyVIP(UserBuyVIPModel model) {
        CreateOrderResult result = new CreateOrderResult();
        ProductOrderPO orderPO = createPO(ProductTypeEnum.USER_VIP,model.getCount(),model.getPayMethod(),model.getCourseId());
        result.setOrderNo(orderPO.getOrderNo());
        if (orderPO.getPayMethod() == PayMethodEnum.WeiXin){
            try {
                Object rtObj = wxCreateOrder(orderPO,model.getSource());
                result.setResult(rtObj);
                save(orderPO);
                return result;
            } catch (WxPayException e) {
                log.error(e.getMessage(),e);
                throw new BusinessException("微信支付异常");
            }
        }else if (orderPO.getPayMethod() == PayMethodEnum.AliPay){
            return result;
        }
        return result;
    }
    private ProductOrderPO createPO(ProductTypeEnum productType, int count, PayMethodEnum payMehtod,Long courseId){
        ProductOrderPO po = new ProductOrderPO();
        po.setOrderNo(generateOrderNo());
        po.setProductType(productType);
        switch (po.getProductType()){
            case USER_VIP:
                po.setOrderName("会员包月");
                String vipPriceStr = sysConfigService.getValueByKey(BizConstants.CONFIG_KEY_VIP_PRICE);
                if (StrUtil.isBlank(vipPriceStr)){
                    throw new BusinessException("处理错误，尚未配置会员价格");
                }
                po.setProductPrice(new BigDecimal(vipPriceStr));
                break;
            case ENTERPRISE_VIP:
                po.setOrderName("企业会员");
                String enterpriseVipPriceStr = sysConfigService.getValueByKey(BizConstants.CONFIG_KEY_ENTERPRICE_VIP_PRICE);
                if (StrUtil.isBlank(enterpriseVipPriceStr)){
                    throw new BusinessException("处理错误，尚未配置企业会员价格");
                }
                po.setProductPrice(new BigDecimal(enterpriseVipPriceStr));
                break;
            case COURSE_BUY:
                CoursePO coursePO = courseService.getById(courseId);
                if (coursePO == null){
                    throw new BusinessException("请求错误，课程不存在");
                }
                String orderName = "付费点播：{}";
                po.setOrderName(StrUtil.format(orderName,coursePO.getName()));
                FullUserInfo userInfo = sysUserService.findFullUserInfo(UserContext.getUser().getUsername());
                if (userInfo.getType() == AccountTypeEnum.USER){
                    po.setProductPrice(coursePO.getPrice());
                }else {
                    po.setProductPrice(coursePO.getVipPrice());
                }
                break;
            default:
                throw new BusinessException("购买产品类型错误");
        }
        po.setProductCount(count);
        po.setOrderMoney(po.getProductPrice().multiply(new BigDecimal(po.getProductCount())));
        po.setPaymentMoney(po.getOrderMoney());
        po.setCourseId(courseId);
        po.setPayMethod(payMehtod);
        po.setStatus(ProductOrderStatusEnum.WAIT_PAY);
        po.setUserId(UserContext.getUserId());
        return po;
    }


    public void updateStatus(String outTradeNo, ProductOrderStatusEnum status) {
        ProductOrderPO po = new ProductOrderPO();
        po.setStatus(status);
        update(po, Wrappers.<ProductOrderPO>lambdaUpdate().eq(ProductOrderPO::getOrderNo,outTradeNo));
    }

    public ProductOrderStatusEnum queryStatus(String orderNo) {
        ProductOrderPO orderPO = getByOrderNo(orderNo);
        if (orderPO == null){
            throw new BusinessException("订单号不存在");
        }
        if (orderPO.getStatus() == ProductOrderStatusEnum.PAY_COMPLETE){
            return ProductOrderStatusEnum.PAY_COMPLETE;
        }else {
            try {
                if (orderPO.getPayMethod() == PayMethodEnum.WeiXin) {
                    if(wxService.getConfig().isUseSandboxEnv()){
                        String key = wxService.getSandboxSignKey();
                        wxService.getConfig().setMchKey(key);
                    }
                    WxPayOrderQueryResult queryResult = wxService.queryOrder(null, orderNo);
                    if ("SUCCESS".equals(queryResult.getTradeState())){
                        return ProductOrderStatusEnum.PAY_COMPLETE;
                    }else {
                        return ProductOrderStatusEnum.PAY_FAILD;
                    }
                }else if (orderPO.getPayMethod() == PayMethodEnum.AliPay){
                    return ProductOrderStatusEnum.PAY_FAILD;
                }else {
                    throw new BusinessException("暂不支持的支付类型");
                }
            } catch (WxPayException e) {
                log.error(e.getMessage(),e);
                return ProductOrderStatusEnum.PAY_FAILD;
            }
        }

    }

    private ProductOrderPO getByOrderNo(String orderNo) {
        return getOne(Wrappers.<ProductOrderPO>lambdaQuery().eq(ProductOrderPO::getOrderNo,orderNo));
    }

    public PageResult<ProductOrderModel> queryPageList(QueryProductOrderModel model) {
        Page page = new Page(model.getPageIndex(),model.getPageSize());
        List<ProductOrderModel> list = baseMapper.queryPageList(page,model);
        for (ProductOrderModel orderModel : list){
            List<SysRoleModel> roleList = roleService.getUserRoles(orderModel.getUserId());
            if (CollUtil.isNotEmpty(roleList)){
                orderModel.setUserRoleName(roleList.get(0).getName());
            }
        }
        return PageResult.<ProductOrderModel>builder().code(CodeEnum.SUCCESS.getCode()).count(page.getTotal()).data(list).build();
    }

    public void orderComplete(String orderNo) {
        updateStatus(orderNo,ProductOrderStatusEnum.PAY_COMPLETE);
        ProductOrderPO orderPO = getByOrderNo(orderNo);
        if (orderPO.getProductType() == ProductTypeEnum.USER_VIP){
            LocalDateTime payCompleteTime = orderPO.getUpdateTime();//支付完成时间,即生效时间
            int month = orderPO.getProductCount();//购买的几个月VIP
            Long userId = orderPO.getUserId();
            sysUserService.updateVIPTimeLimit(userId,payCompleteTime,month);

        }else if (orderPO.getProductType() == ProductTypeEnum.ENTERPRISE_VIP){
            Long orgId = sysUserService.getUserEnterpriesId(orderPO.getUserId());
            if (orgId != null){
                orgSurplusService.updateSurplus(orgId,null,orderPO.getProductType(),orderPO.getProductCount());
            }
        }else if (orderPO.getProductType() == ProductTypeEnum.COURSE_BUY){
            userCourseAuthService.updateAuth(orderPO.getUserId(),orderPO.getCourseId(),orderPO.getUpdateTime());
        }else if (orderPO.getProductType() == ProductTypeEnum.ENTERPRISE_COURSE_BUY){
            Long orgId = sysUserService.getUserEnterpriesId(orderPO.getUserId());
            if (orgId != null){
                orgSurplusService.updateSurplus(orgId,orderPO.getCourseId(),orderPO.getProductType(),orderPO.getProductCount());
            }

        }

    }
}