package com.qkdata.biz.management.service;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.qkdata.biz.enums.ProductTypeEnum;
import com.qkdata.biz.management.entity.OrgSurplusPO;
import com.qkdata.biz.management.mapper.OrgSurplusMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 企业VIP或课程余额 服务类
 * </p>
 *
 * @author liuyang
 * @since 2021-06-03
 */
@Service
public class OrgSurplusService extends ServiceImpl<OrgSurplusMapper, OrgSurplusPO> {

    /**
     * 更新企业VIP或课程余额
     * @param orgId
     * @param courseId
     * @param productType
     * @param count
     */
    public void updateSurplus(Long orgId, Long courseId, ProductTypeEnum productType,Integer count) {
        OrgSurplusPO po = null;
        if (productType == ProductTypeEnum.ENTERPRISE_VIP){
            po = getOne(Wrappers.<OrgSurplusPO>lambdaQuery().eq(OrgSurplusPO::getOrgId,orgId).eq(OrgSurplusPO::getProductType,productType));
        }else if (productType == ProductTypeEnum.ENTERPRISE_COURSE_BUY){
            po = getOne(Wrappers.<OrgSurplusPO>lambdaQuery().eq(OrgSurplusPO::getOrgId,orgId).eq(OrgSurplusPO::getCourseId,courseId).eq(OrgSurplusPO::getProductType,productType));
        }
        if (po == null){
            po = new OrgSurplusPO();
            po.setOrgId(orgId);
            po.setCourseId(courseId);
            po.setProductType(productType);
            po.setCount(count);
            save(po);
        }else {
            po.setCount(po.getCount()+count);
            updateById(po);
        }
    }
}