package com.qkdata.biz.management.controller;


import com.qkdata.biz.common.BizConstants;
import com.qkdata.biz.management.service.OrganizationService;
import com.qkdata.biz.management.vo.InstitutionModel;
import com.qkdata.common.annotation.SysLog;
import com.qkdata.common.base.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 企业 前端控制器
 * </p>
 *
 * @author liuyang
 * @since 2021-04-27
 */
@Api(tags = "企业管理")
@RestController
@RequestMapping("/api/mgr/enterprise")
public class EnterpriseController {

    @Autowired
    private OrganizationService orgService;

    @ApiOperation("添加机构")
    @PostMapping("/save")
    @SysLog(value = "添加培训机构")
    @RequiresRoles(value = {BizConstants.ROLE_ADMIN,BizConstants.ROLE_OPERATOR})
    public Result<String> institutionSave(@RequestBody @Validated InstitutionModel model){

        return Result.succeed("ok");
    }
}
