package com.qkdata.wx.pay.controller;

import com.github.binarywang.wxpay.bean.notify.WxPayNotifyResponse;
import com.github.binarywang.wxpay.bean.notify.WxPayOrderNotifyResult;
import com.github.binarywang.wxpay.bean.notify.WxPayRefundNotifyResult;
import com.github.binarywang.wxpay.bean.notify.WxScanPayNotifyResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import com.qkdata.biz.enums.ProductOrderStatusEnum;
import com.qkdata.biz.management.service.ProductOrderService;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 微信支付回调
 */
@Slf4j
@RestController
@RequestMapping("/wx/pay")
public class WxPayNotifyController {
    @Autowired
    private WxPayService wxPayService;
    @Autowired
    private ProductOrderService orderService;

    @ApiOperation(value = "支付回调通知处理")
    @PostMapping("/notify/order")
    public String parseOrderNotifyResult(@RequestBody String xmlData) throws WxPayException {

        try {
            final WxPayOrderNotifyResult notifyResult = this.wxPayService.parseOrderNotifyResult(xmlData);
            log.info(notifyResult.toString());
            notifyResult.checkResult(wxPayService,notifyResult.getSignType(),true);

            String outTradeNo = notifyResult.getOutTradeNo();
            orderService.updateStatus(outTradeNo, ProductOrderStatusEnum.PAY_COMPLETE);

        }catch (WxPayException e){
            log.error(e.getMessage(),e);
        }
        return WxPayNotifyResponse.success("OK");
    }
    @ApiOperation(value = "退款回调通知处理")
    @PostMapping("/notify/refund")
    public String parseRefundNotifyResult(@RequestBody String xmlData) throws WxPayException {
        final WxPayRefundNotifyResult result = this.wxPayService.parseRefundNotifyResult(xmlData);
        log.info(result.toString());
        // TODO 根据自己业务场景需要构造返回对象
        return WxPayNotifyResponse.success("成功");
    }

    @ApiOperation(value = "扫码支付回调通知处理")
    @PostMapping("/notify/scanpay")
    public String parseScanPayNotifyResult(String xmlData) throws WxPayException {
        final WxScanPayNotifyResult result = this.wxPayService.parseScanPayNotifyResult(xmlData);
        log.info(result.toString());
        // TODO 根据自己业务场景需要构造返回对象
        return WxPayNotifyResponse.success("成功");
    }
}
